/*
sitage - Scale Index TAble GEnerator
By: Pedro Izecksohn
License:
To redistribute you must make the source code available to the receiver.
You must not take the authorship from me, nor modify this license.
*/

#include <stdio.h>
#include <stdlib.h>

int main (int argc, char ** argv) {
double scale, minimum, increment, maximum, index;

if (argc<5) {
fprintf (stderr,
"Usage: sitage scale minimum increment maximum\n"
"All as decimal floating point.\n"
"increment must not be 0 .\n"
);
return EXIT_FAILURE;
}

scale=atof(argv[1]);
minimum=atof(argv[2]);
increment=atof(argv[3]);
maximum=atof(argv[4]);

if (0.0==increment) {
fprintf (stderr, "A 0 increment is unacceptable.\n");
return EXIT_FAILURE;
}

for (index=minimum; index<=maximum; index=(index+increment)) {

printf ("%f\t%f\n", index, (index*scale));

} // for

return EXIT_SUCCESS;
} // main
