#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/mman.h>
#include <sys/stat.h>

int main (int argc, char **argv)
{
  if (argc<2)
  {
    fprintf (stderr, "I need a name for the shm object.\n");
    return EXIT_FAILURE;
  }
  char *name = argv[1];
  int fd = shm_open (name, O_CREAT | O_EXCL, (S_IRUSR|S_IRGRP|S_IROTH) );
  if ( fd < 0 )
  {
    perror ("shm_open");
    return EXIT_FAILURE;
  }
  printf (
    "shmtest: Type d and press ENTER to delete the shm object\n"
    "or press ENTER twice to persist the shm object.\n");
  char c=0;
  scanf ("%c%*c", &c);
  if ('d'==c)
  {
    if (shm_unlink (name))
    {
      perror ("shm_unlink");
      return EXIT_FAILURE;
    }
    printf ("shmtest: The shm object was unlinked.\n");
  }
  return 0;
}
