// Buffer Overflow

#include <signal.h>
#include <stdio.h>
#include <stdlib.h>

#if defined __i386__ || __x86_64__
#else
#error Sorry, I was created for the i386 and x86-64 architectures only.
#endif

int main (int, char**);

void overwrite_main (void)
{
  printf ("Now I\'ll try to overwrite the beginning of main (int, char **).\n");
  char *c;
  c  = (char*) main;
  *c = 0;
  printf ("Succeeded.\n");
}

const char *const code = "\xC3"; // ret

char global_writable;
void call_global_writable (void)
{
  void (*function)();

  global_writable = *code;
  function = (void*) &global_writable;
  printf ("Now I\'ll try to call global writable data located at %p.\n",function);
  function();
  printf ("Succeeded.\n");
}

void call_constant (void)
{
  void (*function)();

  function = (void*) code;
  printf ("Now I\'ll try to call constant data located at %p.\n",function);
  function();
  printf ("Succeeded.\n");

  printf ("Now I\'ll try to overwrite the constant data located at %p.\n",function);
  char *c;
  c = (char*) code;
  *c = (char) 0;
  printf ("Succeeded.\n");
}

void call_malloced (void)
{
  void (*function)();

  if (!(function=malloc(1)))
  {
    perror(NULL);
    exit (EXIT_FAILURE);
  }
  *((char*)function) = *code;
  printf ("Now I\'ll try to call malloced data located at %p.\n",function);
  function();
  printf ("Succeeded.\n");
  free (function);
}

void call_stacked (void)
{
  void (*function)();
  char opcode;

  opcode = *code;
  function = (void*) &opcode;
  printf ("Now I\'ll try to call stacked data located at %p.\n",function);
  function();
  printf ("Succeeded.\n");
}

void set_signal_handler (void);

static void (*previous)(void);
void sighandler (int sig)
{
  if (SIGSEGV!=sig)
  {
    fprintf (stderr, "I received a %u signal that I don\'t know how to deal with it. Exiting.\n", sig);
    exit(EXIT_FAILURE);
  }

  printf ("It caused a SIGSEGV. Continuing.\n");

  if (previous==overwrite_main)
  {
    previous=call_global_writable;
    call_global_writable();
  }
  if (previous==call_global_writable)
  {
    previous=call_constant;
    call_constant();
  }
  if (previous==call_constant)
  {
    previous=call_malloced;
    call_malloced();
  }
  if (previous==call_malloced)
  {
    previous=call_stacked;
    call_stacked();
  }
  if (previous==call_stacked)
  {
    printf ("\nPress enter to exit.");
    getchar();
    exit (0);
  }

  fprintf (stderr, "Which function is at %p ?\n", previous);
  exit (EXIT_FAILURE);
}

void set_signal_handler (void)
{
  sigset_t set;
  if (sigemptyset (&set))
  {
    perror ("sigemptyset");
    exit (EXIT_FAILURE);
  }

  struct sigaction act;
  act.sa_handler = sighandler;
  act.sa_mask = set;
  act.sa_flags = SA_NODEFER;

  if (sigaction (SIGSEGV, &act, NULL))
  {
    perror ("sigaction");
    exit (EXIT_FAILURE);
  }
}

int main (int argc, char ** argv)
{
  printf ("Compiled with "
#if defined __MINGW32_VERSION
  "Mingw version %.2f.\n\n",__MINGW32_VERSION);
#elif defined __GNUC__
  "gcc version %u.%u.\n\n",__GNUC__,__GNUC_MINOR__);
#else
  "unknown compiler.\n");
#endif

  set_signal_handler();

  previous=overwrite_main;
  overwrite_main();

  previous=call_global_writable;
  call_global_writable();

  previous=call_constant;
  call_constant();

  previous=call_malloced;
  call_malloced();

  previous=call_stacked;
  call_stacked();

  printf ("\nPress enter to exit.");
  getchar();
  return 0;
}
